#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// another fractalMod01a.fsh  by   jorge2017a2  
//https://www.shadertoy.com/view/NtcSRf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

///------------image
//por jorge2017a2-
//another fractal
//--13-dic-2021
#define MAX_STEPS 160
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define REFLECT 2
//--------------common
struct Material
{
    vec3 baseCol;
    vec3 specularCol;
    float roughness;
};

struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 phit; //22-mar-2021
    vec3 rf;
    float marchCount;
    bool blnShadow;
    bool hitbln;
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0


vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    //if (i>-1 ) 
	//	return Arrcolores[i];
    
    if (i==0 )  return vec3(0.0);
    if (i==1 )  return vec3(1.0);
    
}

//end common //
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }

#define MENGER_ITERATIONS	2

vec4 mapFractal(in vec3 p)
{	
    p.xz = mod(p.xz + 4.0, 2.0) -1.0;
    //p.y = mod(p.y + 1.0, 2.0) - 1.0;
	
    float d = sdBox(p,vec3(1.0));
    vec4 res = vec4(d, 1.0, 0.01, 0.0);
    float s = 2.5;

    for(int i = 0; i < MENGER_ITERATIONS; ++i)
    {
        vec3 a = mod(p * s, 2.0) - 1.0;
        s *= 11.0;
        vec3 r = abs(1.0 - 5.0 * abs(a));
        float da = max(r.x, r.y);
        float db = max(r.y, r.z);
        float dc = max(r.z, r.x);
        float c = (min(da, min(db, dc)) - 0.85) / s;

        if(c > d)
        {  d = c; res = vec4(d, min(res.y, 0.2 * da * db * dc), 0.0, 1.0); }
    }
    return res;
}

vec3 GetDist(vec3 p  ) 
{	vec3 res= vec3(9999.0, -1.0,-1.0);  vec3 pp=p;
	float planeDist1 = p.y+5.0;  //piso inf
      float t=-iTime*0.5;
    vec4 v4=mapFractal(p-vec3(0.55,1.3,0.0+t));
    res =opU3(res, vec3(v4.x,1.0,-1.0)); 
    //return (dist, id_color, id_material)
    return res;
}

vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 nor = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    nor= normalize(nor);
    return nor;
}

float RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   float t = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    
    #define DISTANCE_BIAS 0.75
    float minDist = 9999.0; 
    
    for(int i=0; i <= PMaxSteps; i++) 
    {  	p = ro + rd*t;
        dS = GetDist(p);
        if ( abs(dS.x)<MIN_DIST  || i == PMaxSteps)
        {mObj.hitbln = true; minDist = abs(t); break;}
        
        if(t>MAX_DIST)
            {mObj.hitbln = false;    minDist = t;    break; } 
        
        t += dS.x;
        marchCount++;
    }
        
    mObj.dist = minDist;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    mObj.phit=p;
    return t;
}



float GetShadow(vec3 p, vec3 plig)
{   vec3 lightPos = plig;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*MIN_DIST*2., l , MAX_STEPS/2);
    if(d<length(lightPos-p)) dif *= .1;
    return dif;
}

float FakeSoftShadow(float result, vec3 LightPos,vec3 point,vec3 normal)
{
    vec3 shadowOffset = normal * 0.2 ;
    int epoch = 5;
    
    float delta = result/float(epoch);
    float lightOffset = 0.2;
    
    for(int i = 0; i<epoch; i++)
    {
        vec3 tmp = LightPos +vec3(0,0,i)*lightOffset;
        float dis=RayMarch(point + shadowOffset,normalize(tmp-point), int( MAX_DIST));
        if (dis< length(tmp-point))
        { result -= delta; }
    }
    return result;
}

float specularBRDF(float roughness, vec3 n, vec3 v, vec3 l)
{
    vec3 h = normalize(v + l);
    float NoV = abs(dot(n, v)) + .1;
    float NoL = clamp(dot(n, l), 0., 1.);
    float NoH = clamp(dot(n, h), 0., 1.);
    float D = (2. + 1. / roughness) * pow(max(1. - NoH * NoH, .0078125), 1. / roughness * .5) / (2. * PI);
    return D / (4. * (NoL + NoV - NoL * NoV));
}

//----------------------------------------------------
//https://www.shadertoy.com/view/ft3SRr
vec3 Shading(vec3 LightPos, vec3 pos, vec3 ro,vec3 baseCol)
{
    //ro=eye
    vec3 L = normalize(LightPos - pos);
    vec3 V = normalize(ro - pos);
    vec3 N = GetNormal(pos);
    vec3 H = normalize(L+V);
    vec3 R = normalize(reflect(-L, N));
    
    float Ambient = 0.1;
       
    float result = max(dot(L,N),0.0)*0.5 + pow(max(dot(H,N),0.0),20.)*0.9;
    result = FakeSoftShadow(result, LightPos,pos,N);
    
    float roughness=4.25;
    vec3 specol=specularBRDF(roughness, N, V, L)*baseCol;
    
    Material mate;
    mate.baseCol = vec3(.38, .02, .02);
    mate.specularCol = vec3(0.56 ,.64, .64);          
    return ((result+Ambient)*baseCol+specol*mate.specularCol)/2.0;
}

vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos)
{  float intensity=1.0;
     vec3 result;
    vec3 sha= Shading(plight_pos,p,ro,colobj);
    result =  sha;
    return result;
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}


vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{  	vec3 colobj; 

    if( mObj.hitbln==false) return  render_sky_color(rd);
    if (id_color<100)
		{ colobj=getColor(int( id_color)); }    
    return colobj;
}

/*
vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
   TObj Obj;
   mObj.rd=rd;
   mObj.ro=ro;
   vec3 p;

   float d=RayMarch(ro,rd, MAX_STEPS);
    Obj=mObj;
    if(mObj.hitbln) 
    {   p = (ro + rd * d );  
        vec3 nor=mObj.normal;
        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1)*light_color1;
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2)*light_color2;
        
        col= result;
        //col *= 1.0 - pow(d*d /(MAX_DIST*1.5) , 4.5);  
    }
    else if(d>MAX_DIST)
    col= render_sky_color(rd);
    
   return col;
}
*/


vec3 Render(vec3 ro, vec3 rd)
{   vec3 col = vec3(0);
    TObj Obj;
    mObj.rd=rd;
    mObj.ro=ro;
 
    float d=RayMarch(ro,rd, MAX_STEPS);
    Obj=mObj;

    vec3 sky = render_sky_color(rd);
    col = sky;

    if(mObj.hitbln) 
    {   vec3 p = (ro + rd * d );  
        vec3 nor=mObj.normal;
        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1)*light_color1;
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2)*light_color2;

        col= result;
        //col *= 1.0 - pow(d*d /(MAX_DIST*1.5) , 4.5);  
    }

    col = mix(col, sky, smoothstep(0., .08, min(d, MAX_DIST)/MAX_DIST));

    return col;
}


vec3 linear2srgb(vec3 c) {
    return mix(
        12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055,
        step(vec3(0.0031308), c));
}

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{    return vec3(1.0) - exp(-hdrColor * exposure);  }

// Tone mapping
// See: http://filmicgames.com/archives/75
vec3 Uncharted2ToneMapping(vec3 color)
{
    float gamma = 2.2;
	float A = 0.15;
	float B = 0.50;
	float C = 0.10;
	float D = 0.20;
	float E = 0.02;
	float F = 0.30;
	float W = 11.2;
	float exposure = 0.012;
	color *= exposure;
	color = ((color * (A * color + C * B) + D * E) / (color * (A * color + B) + D * F)) - E / F;
	float white = ((W * (A * W + C * B) + D * E) / (W * (A * W + B) + D * F)) - E / F;
	color /= white;
	color = pow(color, vec3(1. / gamma));
	return color;
}


///---------------------------------------------
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*1.0,360.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;
        
 	
    light_pos1= vec3(5.0, 10.0, -10.0 );    light_color1=vec3(1.0);
 	light_pos2= vec3( -10.0, 30.0, -10.0 ); light_color2 = vec3(1.0); 
 
   
   vec3 ro=vec3(0.5,2.0,-20.0);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
    
    vec3 col= Render( ro,  rd);
    
    //col = linear2srgb(col);
    col+=Uncharted2ToneMapping(col);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

